% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program PowerAnalysis2.m
function beta = PowerAnalysis(effectSize, Next, sampleSize, ...
      alpha)  

totalN = 500;   % total # of simulations
beta = 1.635;
gamma = 1.96;
Nm = 0.135;
Sa = 0.0095;
Af = 10^(-effectSize/20);
NnoiseLevels = length(Next);

% placement of stimulus contrast
p0 = [0.30 0.39 0.48 0.63 0.78 0.87 0.96];
dp0 = [0.18 0.49 0.78 1.25 1.81 2.26 3.05];
NperformanceLevels = length(dp0);
data1 = zeros(3*NnoiseLevels, NperformanceLevels + 1); 
       % unattended
data2 = zeros(3*NnoiseLevels, NperformanceLevels + 1);  
       % attended

for i = 1: NnoiseLevels
    data1(i, 1) = Next(i);
    data2(i, 1) = Next(i);
    for j = 1:NperformanceLevels
        logC1 = 1 / (2*gamma) * (2*log(dp0(j)) + ...
              log((1+Nm^2) * Next(i).^(2*gamma) + Sa^2) - ...
              log(1-Nm.^2*dp0(j).^2/2)) - log(beta);
        data1(i,  j + 1) = exp(logC1);   
        % stimulus contrast level in the unattended condition
        logC2 = 1 / (2*gamma) * (2*log(dp0(j)) + ...
              log((1+Nm^2) * (Af*Next(i)).^(2*gamma) + Sa^2) ...
              - log(1-Nm.^2*dp0(j).^2/2)) - log(beta);
        data2(i,  j + 1) = exp(logC2);   
        % stimulus contrast level in the attended condition
    end
end
                   
success = 0;
for m = 1 : totalN
    data1((NnoiseLevels+1):(3*NnoiseLevels), :) = 0;
    data2((NnoiseLevels+1):(3*NnoiseLevels), :) = 0;
    for i = 1 : NnoiseLevels
        for j = 1 : NperformanceLevels
            for k = 1 : sampleSize
                x = (-100:100)/10;
                dx = 0.10000000;
                prob = sum(normpdf(x - ...
                       dp0(j)).*normcdf(x).^3)*dx;   
                % compute percent correct from target dprime
                
                r = rand;   % simulate one trial in the 
                            % unattended condition
                if r < prob
                    data1(i + NnoiseLevels, j+1) = ...
                          data1(i + NnoiseLevels, j+1) + 1;
                else
                    data1(i + 2*NnoiseLevels, j+1) = ...
                          data1(i + 2*NnoiseLevels, j+1) + 1;
                end
                
                r = rand;   % simulate one trial in the
                            % attended condition
                if r < prob
                    data2(i + NnoiseLevels, j+1) = ...
                          data2(i + NnoiseLevels, j+1) + 1;
                else
                    data2(i + 2*NnoiseLevels, j+1) = ...
                          data2(i + 2*NnoiseLevels, j+1) + 1;
                end    
            end
        end
    end
    data = [data1; data2];
    
    % full model fit
    guess = [1.5 2 0.1 0.01 10^(-effectSize/20)];
    options = optimset('fminsearch');
    [ptm, minus_maxloglikelihood] = ...
           fminsearch('PTMcostfunct1', guess, options, data);
    fullmodel_maxloglikelihood = - minus_maxloglikelihood;
    
    %reduced model
    guess = [1.5 2 0.1 0.01 10^(-effectSize/20)];
    options = optimset('fminsearch');
    [ptm, minus_maxloglikelihood] = ...
           fminsearch('PTMcostfunct2', guess, options, data);
    reducedmodel_maxloglikelihood = - minus_maxloglikelihood;
 
    chi2 = 2*(fullmodel_maxloglikelihood - ...
           reducedmodel_maxloglikelihood);
    p = 1 - chi2cdf(chi2, 1);

    if p < alpha
        success = success + 1;
    end
end
beta = success/totalN;
